﻿using System;
using System.Collections.Generic;

using VIRP.CRS.BLL;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class FragLabInterpretationFragment : EfrBasePage
    {
        private FRAGMENT_ANALYSIS fragment;

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/LabResults/FragLabResult.aspx",
            "/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretation.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx",
        };

        public FragLabInterpretationFragment()
        {
            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int fragmentId;

                if (int.TryParse(Request.QueryString["fragmentId"], out fragmentId))
                {
                    GetRefreshFragment(fragmentId);
                    SetupFragment();

                    var activity = WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, fragment.WKF_CASE_ACTIVITY_ID);
                    var activityStatus = string.Empty;
                    if (activity != null)
                        activityStatus = STD_WKFACTIVITYSTSManager.GetItem(CurrentUser, CurrentRegistryId, activity.STD_WKFACTIVITYSTS_ID).NAME;

                    ReplacePageTitle("My Tasks > Interpretation & Follow Up > " + activityStatus + " > Workflow ID " + activity.WKF_CASE_ID.ToString() + " > Fragments > Fragment ID > " + fragmentId.ToString());
                }

                SetReferringPage();
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewAnalyteData.ClientID + "');", true);
        }

        private void SetupFragment()
        {
            lblFragmentId.Text = fragment.FRAGMENT_ID_NUMBER;
            lblFragDesc.Text = fragment.FRAGMENT_DESCR;
            lblFragMass.Text = fragment.FRAGMENT_MASS_MEASURE;
            lblMassmsrmts.Text = fragment.MASS_UNITS;
            lblLength.Text = string.IsNullOrEmpty(fragment.FRAGMENT_LENGTH_MEASURE) ? string.Empty : fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[0];

            if (!string.IsNullOrEmpty(fragment.FRAGMENT_LENGTH_MEASURE))
            {
                if (fragment.FRAGMENT_LENGTH_MEASURE.Split(' ').Length > 1)
                    lblLengthmsrmts.Text = fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[1];

                lblHeight.Text = string.IsNullOrEmpty(fragment.FRAGMENT_HEIGHT_MEASURE) ? string.Empty : fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[0];
            }

            if (!string.IsNullOrEmpty(fragment.FRAGMENT_HEIGHT_MEASURE))
            {
                if (fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ').Length > 1)
                    lblHeightmsrmts.Text = fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[1];
            }

            if (!string.IsNullOrEmpty(fragment.FRAGMENT_WIDTH_MEASURE))
            {
                lblWidth.Text = string.IsNullOrEmpty(fragment.FRAGMENT_WIDTH_MEASURE) ? string.Empty : fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[0];
                if (fragment.FRAGMENT_WIDTH_MEASURE.Split(' ').Length > 1)
                    lblWidthmsrmts.Text = fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[1];
            }

            lblRadioactive.Text = !string.IsNullOrEmpty(fragment.FRAGMENT_RADIOACTIVE_TEST_IND) 
                ? fragment.FRAGMENT_RADIOACTIVE_TEST_IND.Equals("Y", StringComparison.OrdinalIgnoreCase) ? "Yes" : "No" : "Not Tested";

            lblRadActiveTestResult.Text = fragment.FRAGMENT_RADIOACTIVE_RESULT;
            lblComments.Text = fragment.COMMENT_TEXT;
            lblTissueSent.Text = fragment.TISSUE_SENT_FLAG ? "Yes" : "No";
            lblTissueResults.Text = fragment.TISSUE_RESULT_TEXT;

            BindGridView();
        }

        private void GetRefreshFragment(int FRAGMENT_ANALYSIS_ID)
        {
            fragment = FRAGMENT_ANALYSISManager.GetItem(CurrentUser, CurrentRegistryId, FRAGMENT_ANALYSIS_ID);
        }

        private void BindGridView()
        {
            if (fragment != null)
            {
                var details = ANALYSIS_DETAILManager.GetItemsByFragment(CurrentUser, CurrentRegistryId, fragment.FRAGMENT_ANALYSIS_ID);
                GridViewAnalyteData.DataSource = details;
            }
            else
                GridViewAnalyteData.DataSource = new List<ANALYSIS_DETAIL>();

            GridViewAnalyteData.DataBind();
        }

        protected void CancelButton_OnClick(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }
    }
}
